#!/bin/sh

# nagios plugin for checking amrstat output
# amrstat is a FreeBSD port of a utility for getting information from
# LSI Logic's MegaRAID RAID controllers.

# Likely remotely invoked by an snmpd exec or nrpe or check_by_ssh or ...
# Must run as root to open the device

# Optional argument specifies the controller number, default is 0.
# Argument parsing is very simple minded.

PATH=/usr/local/sbin:/bin:/usr/bin:/usr/local/bin
export PATH

myname=`basename "$0"`
OK=0
WARNING=1
CRITICAL=2
UNKNOWN=3

tmp="/tmp/$myname.$$"
rm -f "$tmp"
trap "rm -f '$tmp'" EXIT


msg=""
str="OK"
res=$OK

cnum="0"
if [ $# -eq 1 ]; then
    cnum="$1"
fi

echo "" > "$tmp"
errstr=`( amrstat -g -c "$cnum" >> "$tmp" ) 2>&1`
if [ $? -ne 0 ]; then
    msg="${msg}amrstat failed: $errstr; "
    str="CRITICAL"
    res=$CRITICAL
fi

awkstr=`tr -s '\t' < "$tmp" \
| awk '
    BEGIN { FS = "\t"; ok = 1; battmsg = "Battery OK"; }
    $1 == "Battery status" {
	battery = 1;
	if ( $2 != "charge done" ) {
	    battmsg = "Battery " $2;
	    ok = 0;
	}
	next;
    }
    $1 ~ /^Logical volume/ {
	if ( $2 ~ /^optimal / ) {
	    logical++;
	} else {
	    printf " %s %s;", $1, $2;
	    ok = 0;
	}
	next;
    }
    $1 ~ /^Physical drive/ {
	if ( $2 == "online" ) {
	    physical++;
	} else {
	    printf " %s %s;", $1, $2;
	    ok = 0;
	}
	next;
    }
    # { print "option", $1, $2, " -- "; }
    END {
	if ( battery ) {
	    printf " %s;", battmsg;
	} else {
	    printf " no battery state;";
	    ok = 0;
	}
	if ( logical > 0 ) {
	    printf " %s logical volumes OK;", logical;
	} else {
	    printf " no logical volumes;";
	    ok = 0;
	}
	if ( physical > 0 ) {
	    printf " %s physical drives OK;", physical;
	} else {
	    printf " no physical drives;";
	    ok = 0;
	}
	print "";	# the newline
	exit( ok ? 0 : 1 );
    }'`
if [ $? -ne 0 ]; then
    str="CRITICAL"
    res=$CRITICAL
fi
msg="${msg}$awkstr"

echo "${str}: $msg" | sed -e 's/  */ /g'
exit $res
