#!/bin/sh

# checks overall compaq server status
# same args as check_snmp, but don't provide -o oid

# John Sellens, Magna

# this is the overall status of the server:
# enterprises.compaq.cpqStdEquipment.cpqSeMibRev.cpqSeMibCondition.0 
oid=".1.3.6.1.4.1.232.1.1.3.0"

csnmp=/usr/local/nagios/libexec/check_snmp


msg=`$csnmp -o "$oid" "$@"`
res=$?
if [ "$res" != 0 ]; then
    echo "snmp query failed ($res): $msg"
    exit 2
fi

case "$msg" in
    "SNMP OK - 2")
	echo "Compaq server agent reports all OK"
	;;
    *)
	# we're just guessing here ....
    	echo "Compaq server NOT OK - check server for details"
	res=2
	;;
esac


exit $?
