#!/bin/sh

# use tclwebtest to log in to an ECQ2 EDI server
# if we can log in, then the backend database must be up and happy

# usage: check_ecq_login hostname userid password

PATH=/usr/local/nagios/libexec:/usr/local/bin:/bin:/usr/bin
export PATH

umask 077
myname=`basename "$0"`

tmpin=/tmp/check_ecq.in.$$
tmpout=/tmp/check_ecq.out.$$

trap "rm -f $tmpin $tmpout" EXIT
rm -f "$tmpin" "$tmpout"

if [ $# -ne 3 ]; then
    echo "$myname: ERROR: need exactly 3 args, not $#"
    exit 3
fi
hostname="$1" ; shift
userid="$1" ; shift
password="$1" ; shift


cat <<EOF >>"$tmpin"
set SERVER "$hostname"
do_request "http://$hostname/login.asp"

# assert text "some text"

field fill "$userid"
field fill "$password"

form submit

assert text "ECQ2 - Main Menu"
EOF


tclwebtest "$tmpin" > "$tmpout"
code=$?

if [ $code -eq 0 ]; then
    echo "OK: login as $userid succeeded"
else
    echo "CRITICAL: login as $userid failed"
    code=2	# nagios critical
    # echo 1>&2 "$myname: tclwebtest output is"
    # cat 1>&2 "$tmpout"
fi

exit "$code"
