#!/bin/sh

# checks that an outbound TCP connection is established

# doesn't do performance data (thought it would be trivial to add)
# argument "parsing" is rudimentary

PATH=/bin:/usr/bin:/usr/local/bin
export PATH

myname=`basename "$0"`
OK=0
WARNING=1
CRITICAL=2
UNKNOWN=3

usage="usage: $myname host comm remip remport"

tmpout="/tmp/$myname.out.$$"
trap "rm -f $tmpout" EXIT
rm -f "$tmpout"


if [ "$#" -ne 4 ]; then
    echo "$myname: $usage"
    exit $UNKNOWN
fi

host="$1"; shift
comm="$1"; shift
remip="$1"; shift
remport="$1"; shift

snmptable -v 1 -c "$comm" "$host" \
    tcpConnTable \
    > "$tmpout"

if [ ! -s "$tmpout" ]; then
    echo "$myname: no tcpConnTable data received"
    exit $CRITICAL
fi

# Oh, now this is a hack - using awk exit code to provide average
msg=`awk < "$tmpout" -v remip="$remip" -v remport="$remport" '
	$1=="established" && $4==remip && $5==remport {
	    gsub( /  */, " " );
	    sub( /^  */, "" );
	    printf "connection established to %s/%s\n", remip, remport;
	    found = 1;
	    exit 0
	}
	END {
	    if ( found != 1 ) {
		printf "no established connection to %s/%s\n", remip, remport;
		exit 1;
	    }
	}
	'`
res=$?


if [ "$res" -ne 0 ]; then
    code="$CRITICAL"
    str="CRITICAL"
else
    code="$OK"
    str="OK"
fi

echo "$str - $msg"
exit $code

