#!/bin/sh

# make sure that the vmware ESX snmp sub-agent is running
# I've seen cases where it doesn't answer, or isn't hooked up
# with the master agent
# - John Sellens

# this is fairly specific ...

# use SNMPCOMM as community to look in the environment

PATH=/usr/local/nagios/libexec:/usr/local/bin:/bin:/usr/bin
export PATH

myname=`basename "$0"`

usage="$myname hostname community [expected_string]"
# this is enterprises.vmware.vmwSystem.vmwProdName.0
oid=".1.3.6.1.4.1.6876.1.1.0"

if [ $# -gt 3 ]; then
    echo "$myname: too many arguments ($#): Usage: $usage"
    exit 3
fi
if [ $# -lt 2 ]; then
    msg="$myname: missing hostname or community: Usage: $usage"
    # too much noise
    # echo 1>&2 "$msg"
    echo "$msg"
    exit 3
fi
host="$1"
comm="$2"
if [ "$comm" = "SNMPCOMM" ]; then
    if [ ! -z "$SNMPCOMM" ]; then
	comm="$SNMPCOMM"
    fi
fi
string="VMware ESX Server"
if [ "$3" != "" ]; then
    string="$3"
fi

msg=`check_snmp -H "$host" -o "$oid" -C "$comm" -s "$string"`
res=$?

if [ "$res" -ne 0 ]; then
    msg="$msg -- expected '$string' -- you may need to stop (both) and then start the snmpd and vmware-snmpd services"
fi

echo "$msg"
exit "$res"
