#!/bin/sh

# nagios plugin for checking geom mirror/gmirror output on FreeBSD

# Likely remotely invoked by an snmpd exec or nrpe or check_by_ssh or ...

# Checks everything listed by gmirror.
# The assumption is that if a volume has disappeared, it will no longer
# be mounted, and some other check will fail.
# What we do is check gmirror output, and look for any problems.


PATH=/sbin:/usr/sbin:/bin:/usr/bin
export PATH

myname=`basename "$0"`
OK=0
WARNING=1
CRITICAL=2
UNKNOWN=3

tmp="/tmp/$myname.$$"
rm -f "$tmp"
trap "rm -f '$tmp'" EXIT


msg=""
str="OK"
res=$OK


echo "" > "$tmp"
errstr=`( gmirror status >> "$tmp" ) 2>&1`
if [ $? -ne 0 ]; then
    msg="${msg}gmirror failed: $errstr; "
    str="CRITICAL"
    res=$CRITICAL
fi

awkstr=`awk < "$tmp" '
    BEGIN { ok = 1; }
    NF == 0 { next; }
    /^ / { next; }
    $1 ~ /^mirror/ {
	if ( $2 == "COMPLETE" ) {
	    mirrors++;
	} else {
	    printf " %s %s;", $1, $2;
	    ok = 0;
	}
	next;
    }

    {
	printf " unrecognized: %s;", $0;
	ok = 0;
	next;
    }

    END {
	if ( mirrors > 0 ) {
	    printf " %s mirrors OK;", mirrors;
	} else {
	    printf " no OK mirrors;";
	    ok = 0;
	}
	print "";	# the newline
	exit( ok ? 0 : 1 );
    }'`
if [ $? -ne 0 ]; then
    str="CRITICAL"
    res=$CRITICAL
fi
msg="${msg}$awkstr"

echo "${str}: $msg" | expand | sed -e 's/  */ /g'
exit $res
