#!/bin/sh

# checks a weathergoose door sensor
# there's supposed to be a doorSensorTable, but it ain't on ours
# - John Sellens

# this is fairly specific ...

PATH=/usr/local/nagios/libexec:/usr/local/bin:/bin:/usr/bin
export PATH

myname=`basename "$0"`

usage="$myname hostname community door"
# this is enterprises.itwatchdogs.wxGoos.internalTable.internalEntry
oid=".1.3.6.1.4.1.17373.2.2.1"
# our door sensors are .internalIO1 and 02, which are .10 .11 and .12
# with an instance of .1, so the first door is $oid.10.1
offset=9

if [ $# -ne 3 ]; then
    msg="$myname: missing argument: Usage: $usage"
    echo "$msg"
    exit 3
fi
host="$1"
comm="$2"
door="$3"
fulloid=$oid.`expr "$offset" + "$door"`.1

msg=`check_snmp -H "$host" -o "$fulloid" -C "$comm"`
res=$?

if [ "$res" -ne 0 ]; then
    msg="Error: Door check failed: $msg"
else
    val=`echo "$msg" | awk '{print $NF}'`
    if [ "$val" == "0" ]; then
	msg="OK: Door sensor $door reports closed ($val)"
    else
	msg="CRITICAL: Door sensor $door reports not closed ($val)"
	res=2
    fi
fi

echo "$msg"
exit "$res"
