#!/bin/sh

# Check traceroute hop count for min/max range.
# Handy if you need to check if a network link has failed over.
# Outside range is critical - no warning level exit.

# Could add a timeout ...
# Could be a little smarter ...
# Could collect performance data from the traceroute output ...
# John Sellens

PATH=/bin:/usr/bin:/usr/local/bin:/sbin:/usr/sbin
export PATH

myname=`basename "$0"`

usage="$myname [-m minhops] [-M maxhops] host"

OK=0
WARNING=1
CRITICAL=2
UNKNOWN=3


tmpout="/tmp/check_hops.$$"
trap "rm -f $tmpout" EXIT
rm -f "$tmpout"

# min and max hops defaults
min=3
max=6
# unsophisticated arg parsing
while [ $# -gt 0 ]; do
    case "$1" in
	-m)
	    min="$2"
	    shift
	    ;;
	-M)
	    max="$2"
	    shift
	    ;;
	-*)
	    echo "$myname: unknown option $1 -- usage: $usage"
	    exit $UNKNOWN
	    ;;
	*)
	    break
	    ;; 
    esac
    shift
done
if [ $# -ne 1 ]; then
    echo "$myname: usage: $usage"
    exit $UNKNOWN
fi
host="$1"

# traceroute prints the header line on stderr
# we could have -q1 here, but we're currently dropping some icmp packets
traceroute -q3 -n "$host" >"$tmpout" 2>&1
if [ $? -ne 0 ]; then
    echo "$myname: traceroute $host failed" `cat "$tmpout"`
    exit $UNKNOWN
fi

# count the hops it took - hoping that traceroute output is predictable
set -- `tail -1 "$tmpout"`
hops=$1
if [ "$min" -le "$hops" -a "$hops" -le "$max" ]; then
    msg="OK: traceroute $host took $hops hops, in range ${min}:${max}"
    # msg="$msg - "`tr '\n' '/' <$tmpout`
    res=$OK
else
    msg="CRITICAL: traceroute $host took $hops hops, NOT in range ${min}:${max}"
    msg="$msg - "`tr '\n' '/' <$tmpout`
    res=$CRITICAL
fi

echo "$msg"
exit $res
