#!/bin/sh

# nagios plugin for doing a VERY SIMPLE inode check
# likely remotely invoked by an snmpd exec

# hardcoded limits, which may not be optimal

PATH=/bin:/usr/bin:/usr/local/bin
export PATH

myname=`basename "$0"`
OK=0
WARNING=1
CRITICAL=2
UNKNOWN=3

tmp="/tmp/$myname.$$"
rm -f "$tmp"
trap "rm -f '$tmp'" EXIT

pwarn=70
pcrit=80

msg="inodes: "
str="OK"
res=$OK

df -i -l -P \
| awk 'NR==1 { next; } { sub( /%/, "", $5 ); print $6, $5 }' > "$tmp"

while read fs pct ; do
    # echo got $fs $pct
    if [ "$pct" -gt "$pcrit" ]; then
	str="CRITICAL"
	res=$CRITICAL
	# echo BAD $fs $pct $pcrit
	msg="$msg$fs=$pct%>$pcrit; "
    elif [ "$pct" -gt "$pwarn" ]; then
	if [ "$res" -lt "$WARNING" ]; then
	    str="WARNING"
	    res=$WARNING
	fi
	msg="$msg$fs=$pct%>$pwarn; "
    fi
done < "$tmp"


if [ -z "$msg" ]; then
    msg="usage percentages within limits ($pwarn/$pcrit)"
fi

echo "${str}: $msg" | sed -e 's/  */ /g'
exit $res
