#!/bin/sh

# Check for netapp snapmirror problems
# High lag time, failed State, etc.
# done via ssh, assuming a key is in place, and same userid we're running as
# e.g.
# secureadmin ssh setup
# secureadmin enable ssh2
# useradmin role add monitor -a cli-snapvault,cli-snapmirror
# useradmin group add monitor -r monitor
# useradmin user add nagios -g monitor
# put the nagios key into /etc/sshd/nagios/.ssh/authorized_keys

# - John Sellens

PATH=/usr/local/nagios/libexec:/usr/local/bin:/bin:/usr/bin
export PATH

myname=`basename "$0"`
tmpout="/tmp/$myname.out.$$"
trap "rm -f $tmpout" EXIT

usage="$myname hostname"

if [ $# -ne 1 ]; then
    msg="$myname: missing hostname: Usage: $usage"
    # too much noise
    # echo 1>&2 "$msg"
    echo "$msg"
    exit 3
fi
host="$1"

# We could use the -l option for long output, but the parsing
# would be somewhat harder.  But we could get error messages.
# This should do for now.
rm -f "$tmpout"
ssh "$host" snapmirror status > "$tmpout"
if [ $? -ne 0 ]; then
    echo "$myname: 'ssh $host snapmirror status' failed"
    exit 3
fi


# we expect awk to print one line
awk < "$tmpout" '
BEGIN { msg = ""; }
/Snapmirror is on/ { next; }
/^Snapmirror/ {		# some other status like off
    msg = msg $0 "; ";
    critical = 1;
    next;
}
$1=="Source" && $2=="Destination" { next; }
$3 == "Broken-off" { off++; next; }
$3 == "Uninitialized" {
    msg = msg "Uninitialized: " $1 " to " $2 "; ";
    warning = 1;
    next;
}
$3 != "Snapmirrored" && $3 != "Source" {
    msg = msg "Unexpected state " $3 " for " $1 " to " $2 "; ";
    unknown = 1;
}
$5 != "Idle" && $5 != "Pending" && $5 != "Transferring" {
    msg = msg "Unexpected status " $5 " for " $1 " to " $2 "; ";
    unknown = 1;
}
{
    laghours = $4;
    sub( /:.*$/, "", laghours );
    if ( laghours > 72 ) {
	msg = msg "Lag > 72 hours " $4 " for " $1 " to " $2 "; ";
	critical = 1;
    } else if ( laghours > 36 ) {
	msg = msg "Lag > 36 hours " $4 " for " $1 " to " $2 "; ";
	warning = 1;
    }
}
END {
    if ( msg == "" ) {
	msg = "Snapmirror status OK";
    }
    if ( off ) {
	msg = msg off " mirror(s) off; ";
    }
    if ( critical ) {
	msg = "CRITICAL: " msg;
	errcode = 2;
    } else if ( warning ) {
	msg = "WARNING: " msg;
	errcode = 1;
    } else if ( unknown ) {
	msg = "UNKNOWN: " msg;
	errcode = 3;
    } else {
	msg = "OK: " msg;
	errcode = 0;
    }
    print msg;
    exit errcode;
}
'

exit $?
