#!/bin/sh

PATH=/bin:/usr/bin:/usr/local/bin
export PATH

myname=`basename "$0"`

usage="$myname host community extName"
# e.g. check_snmpexec pbx02.tor.magna.intranet angam check_zaptel

OK=0
WARNING=1
CRITICAL=2
UNKNOWN=3

# default timeout for snmp queries
TIMEOUT=20



# enterprises.ucdavis.extTable.extEntry.extIndex.1 = 1
# enterprises.ucdavis.extTable.extEntry.extNames.1 = check_zaptel
# enterprises.ucdavis.extTable.extEntry.extCommand.1 = /master/data/global/bin/check_zaptel
# enterprises.ucdavis.extTable.extEntry.extResult.1 = 0
# enterprises.ucdavis.extTable.extEntry.extOutput.1 = OK: WPT1/5: B8ZS/ESF OK; WPT1/1: B8ZS/ESF OK; WPT1/2: B8ZS/ESF OK; WPT1/3: B8ZS/ESF OK; WPT1/4: B8ZS/ESF OK; 
# enterprises.ucdavis.extTable.extEntry.extErrFix.1 = 0
# enterprises.ucdavis.extTable.extEntry.extErrFixCmd.1 = 


if [ $# -ne 3 ]; then
    echo "$myname: need exactly 3 args: $usage"
    exit $UNKNOWN
fi
host="$1"
comm="$2"
name="$3"

# first, find which index belongs to the command we're looking for

# do we need any funny format args here?
# take the first match we find, just in case there is more than one
# we could cache the answer ..
num=`snmpwalk -t $TIMEOUT -v 1 -c "$comm" "$host" \
    enterprises.ucdavis.extTable.extEntry.extNames \
    | sed -e "/ $name\$/!d" -e 's/ *= .*//' -e 's/.*\.//' \
    | head -1`
if [ $? -ne 0 -o -z "$num" ]; then
    echo "$myname: snmp search for '$name' failed"
    exit $UNKNOWN
fi

# let's continue on blind faith here that num is actually a single number

# -Ov - value output only
set -- `snmpget -t $TIMEOUT -Ov -v 1 -c "$comm" "$host" \
    "enterprises.ucdavis.extTable.extEntry.extResult.$num" \
    "enterprises.ucdavis.extTable.extEntry.extOutput.$num"`
if [ $? -ne 0 ]; then
    echo "$myname: snmp get for '$name' failed"
    exit $UNKNOWN
fi
if [ $# -eq 0 ]; then
    echo "$myname: snmp get for '$name' gave no results (timeout?)"
    exit $UNKNOWN
fi

if [ "$1" = "INTEGER:" ]; then
    shift
fi
res="$1"
shift
if [ "$1" = "STRING:" ]; then
    shift
fi
case "$1" in
    enterprises.ucdavis.extTable.extEntry.extOutput*)
	echo -n "snmp exec failed, blocked by selinux? "
	;;
esac
echo "$@"
exit "$res"
