#!/bin/sh

# nagios plugin for checking asterisk pri span status
# likely remotely invoked by an snmpd exec

PATH=/bin:/usr/bin:/usr/sbin:/usr/local/bin
export PATH

myname=`basename "$0"`
OK=0
WARNING=1
CRITICAL=2
UNKNOWN=3

zcfg=/etc/zaptel.conf

if [ ! -f "$zcfg" ]; then
    echo "CRITICAL: $zcfg is not a file"
    exit $CRITICAL
fi

spans=`sed -e '/^span *=/!d' -e 's/span *= *//' -e 's/ *,.*$//' "$zcfg"`
if [ $? -ne 0 ]; then
    echo "CRITICAL: failed looking for spans in $zcfg"
    exit $CRITICAL
fi

res=$OK
str="OK"
msg="Span(s):"
for n in $spans ; do
    # echo check span x${n}x
    s=`asterisk -r -x "pri show span $n" | sed -e '/^Status: */!d' -e 's///'`
    case "$s" in
	"Provisioned, Up, Active")
	    s="Up/Active"
	    v=""
	    ;;
	*)
	    v=" Unrecognized"
	    res=$CRITICAL
	    str="CRITICAL"
	    ;;
    esac
    msg="$msg${n}: $s$v; "
done

echo "${str}: $msg" | sed -e 's/  */ /g'
exit $res
