#!/bin/sh

# This is a cover script for check_allstorage and the check_inodes snmp check

PATH=/usr/local/nagios/libexec:/usr/local/bin:/bin:/usr/bin
export PATH
umask 022

myname=`basename "$0"`

# cache directory for check_inodes not implemented on remote host
# if we know check_inodes doesn't work there, then we put a flag
# file here, and if we never read it, it will get tmp cleaned in
# a few days, and we'll check again to see if check_inodes is
# now supported
iflags=/tmp/no_check_inodes
mkdir -p "$iflags"



# first things first - we invoke check_allstorage as we were called
msg=`check_allstorage "$@"`
res=$?

# now, if check_allstorage was not happy, we'll just bail out here
if [ "$res" -ne 0 ]; then
    echo "$msg"
    exit "$res"
fi

# since check_allstorage did not complain, we'll do the remote
# check_inodes if we can

# Look for the SNMP community
comm="public"
if [ ! -z "$SNMPCOMM" ]; then
    comm="$SNMPCOMM"
fi
host="nohostgiven"
while [ $# -gt 0 ]; do
    if [ "$1" = "-C" ]; then
	shift
	comm="$1"
    fi
    if [ "$1" = "-H" ]; then
	shift
	host="$1"
    fi
    shift
done

if [ -f "$iflags/$host" ]; then
    # not implemented on this host, so exit with check_allstorage results
    echo "$msg"
    exit "$res"
fi

imsg=`check_snmpexec "$host" "$comm" check_inodes`
ires=$?

# Now, if the message looks like
# snmp search for 'check_inodes' failed
case "$imsg" in
    *snmp\ search\ for\ \'check_inodes\'\ failed*)
	# make our flag file so we don't try again
	date > "$iflags/$host"
	# and pretend there was no complaint
	ires=0
	imsg=""
	;;
esac

# if check_inodes complained, exit with that message
if [ "$ires" -ne 0 ]; then
    echo "$imsg"
    exit "$ires"
fi

# otherwise, just exit with the allstorage message 
# and add the check_inodes message on for the heck of it
echo "$msg" "$imsg"
exit "$res"
