#!/bin/sh

# nagios plugin for doing a VERY SIMPLE timestamp file check
# likely remotely invoked by an snmpd exec

# usage: check_timestamp timestampname

# the timestamp files are in $tdir, and the first line is ctime of creation

# hardcoded limits, which may not be optimal
# duh

PATH=/bin:/usr/bin:/usr/local/bin
export PATH

myname=`basename "$0"`
OK=0
WARNING=1
CRITICAL=2
UNKNOWN=3

# tmp="/tmp/$myname.$$"
# rm -f "$tmp"
# trap "rm -f '$tmp'" EXIT

tdir=/tmp/timestamps

# in seconds - more than 1 hour, more than 2 hours, with a little slop
swarn=3660
scrit=7260
# more than 2 hours, 10 hours - don't complain too early
swarn=7260
scrit=36060

msg=""
str="OK"
res=$OK

if [ "$1" = "" -o $# -ne 1 ]; then
    echo "USAGE - exactly one argument required"
    exit $CRITICAL
fi

cd "$tdir"
if [ $? -ne 0 ]; then
    echo "CRITICAL - could not cd $tdir to check timestamp '$1'"
    exit $CRITICAL
fi
if [ ! -f "$1" ]; then
    echo "CRITICAL - timestamp file '$1' does not exist in $tdir"
    exit $CRITICAL
fi
if [ ! -s "$1" ]; then
    echo "CRITICAL - timestamp file '$1' is empty in $tdir"
    exit $CRITICAL
fi

now=`date +%s`
stamp=`head -1 "$1"`
gap=`expr "$now" - "$stamp"`


if [ "$gap" -gt "$scrit" ]; then
    overage=`expr "$gap" - "$scrit"`
    str="CRITICAL"
    res=$CRITICAL
    msg="timestamp $1 is $overage seconds older than critical - $gap>$scrit; "
elif [ "$gap" -gt "$swarn" ]; then
    overage=`expr "$gap" - "$swarn"`
    str="WARNING"
    res=$WARNING
    msg="timestamp $1 is $overage seconds older than warning - $gap>$swarn; "
else
    msg="timestamp $1 is within normal range - $gap<$swarn; "
fi


echo "${str}: $msg" | sed -e 's/  */ /g'
exit $res
