#!/bin/sh


PATH=/usr/local/libexec/netsaint:/bin:/usr/bin:/usr/local/bin
export PATH

# check_ucdload host community w1 c1 w5 c5 w15 c15

uf=enterprises.ucdavis.laTable.laEntry.laLoad
ui=enterprises.ucdavis.laTable.laEntry.laLoadInt
label=UCDLOAD

# # net-snmp5
# # output=`snmpget -OQ -Ou -v 1 -c "$2" "$1" "$uf.1" "$uf.2" "$uf.3" "$ui.1" "$ui.2" "$ui.3"`
# output=`snmpget -OQ -Ou -v 1 -c "$2" "$1" "$uf.1" "$uf.2" "$uf.3"`

# net-snmp4 / ucd-snmp4
# output=`snmpget "$1" "$2" "$uf.1" "$uf.2" "$uf.3" "$ui.1" "$ui.2" "$ui.3"`
output=`snmpget "$1" "$2" "$uf.1" "$uf.2" "$uf.3"`

result=$?
if [ $result -ne 0 -o "$output" = "" ]; then
    echo "$label UNKNOWN - load get failed: $output"
    exit 3
fi


exec awk <<EOF "BEGIN {w1=$3; c1=$4; w5=$5; c5=$6; w15=$7; c15=$8;} "'
NR==1 { l1=$3 }
NR==2 { l5=$3 }
NR==3 { l15=$3 }
END {
    if ( l1 > c1 || l5 > c5 || l15 > c15 ) {
	printf "UCDLOAD CRITICAL - load avg is %s/%s/%s; limits %s/%s/%s\n",
	    l1, l5, l15, c1, c5, c15;
	exit 2
    }
    if ( l1 > w1 || l5 > w5 || l15 > w15 ) {
	printf "UCDLOAD WARNING - load avg is %s/%s/%s; limits %s/%s/%s\n",
	    l1, l5, l15, w1, w5, w15;
	exit 1
    }
    printf "UCDLOAD OK - load avg is %s/%s/%s; limits %s/%s/%s\n",
	l1, l5, l15, w1, w5, w15;
    exit 0
}'
$output
EOF
