#!/bin/sh

# nagios plugin for checking zaptel device status
# likely remotely invoked by an snmpd exec

PATH=/bin:/usr/bin:/usr/local/bin
export PATH

myname=`basename "$0"`
OK=0
WARNING=1
CRITICAL=2
UNKNOWN=3

zdir=/proc/zaptel

if [ ! -d "$zdir" ]; then
    echo "CRITICAL: $zdir is not a directory"
    exit $CRITICAL
fi

devs=`ls "$zdir/." | sort -n`
if [ -z "$devs" ]; then
    echo "CRITICAL: $zdir has no devices in it"
    exit $CRITICAL
fi

res=$OK
str="OK"
for d in $devs ; do
    h=`head -1 "$zdir/$d"`
    # 3 should be the device type and span
    n=`echo "$h" | awk '{print $3}'`
    s=`echo "$h" | sed -e 's/.*" *//' -e 's/ *$//'`
    # this enumeration is kind of silly - there should be a better way
    case "$s" in
	"B8ZS/ESF")
	    v="OK"
	    ;;
	"B8ZS/ESF ClockSource")
	    v="OK"
	    ;;
	"HDB3/CCS/CRC4")
	    v="OK"
	    ;;
	"HDB3/CCS ClockSource")
	    v="OK"
	    ;;
	"HDB3/CCS")
	    v="OK"
	    ;;
	"")
	    v="OK"
	    ;;
	*)
	    v="Unrecognized"
	    res=$CRITICAL
	    str="CRITICAL"
	    ;;
    esac
    msg="$msg${n}: $s $v; "
done

echo "${str}: $msg" | sed -e 's/  */ /g'
exit $res
