#!/bin/sh

# expects to receive as args:
# $HOSTNAME$ $SERVICESTATE$ $STATETYPE$ $SERVICEATTEMPT$ '$SERVICEDESC$' '$OUTPUT$' '$EXECUTIONTIME$'

# if a failed autosupport message is the problem, try and send one manually
# with the command
#    options autosupport.doit "testing - nagios handler fix"
# done via ssh, assuming a key is in place, and same userid we're running as
# e.g.
# secureadmin ssh setup
# secureadmin enable ssh2
# useradmin role add monitor -a cli-snapvault,cli-snapmirror,cli-options
# useradmin group add monitor -r monitor
# useradmin user add nagios -g monitor
# put the nagios key into /etc/sshd/nagios/.ssh/authorized_keys


PATH=/bin:/usr/bin:/usr/local/bin
export PATH
myname=`basename "$0"`

if [ $# -ne 7 ]; then
    echo 1>&2 "$0: expected exactly 7 args, got $#"
    exit 1
fi
host="$1"
state="$2"
type="$3"
attempt="$4"
desc="$5"
output="$6"
exectime="$7"

sname=`echo "$desc" | sed -e 's/ /_/g'`

# mailto="cust-kwikfly-notify@certaintysolutions.com pagenagios-admin"
# mailto="cust-kwikfly-notify@certaintysolutions.com"
mailto="jsellens@syonex.com"
debugmail="jsellens@syonex.com"
mailto="john_sellens@msi-it.com"
debugmail="john_sellens@msi-it.com"

# echo "hello there from $myname host $host state $state type $type attempt $attempt" | mail -s "fix $sname on $host" $debugmail


# name a lock directory for the day and hour - only send mail if we can
# create the directory, which means that we haven't done it recently,
# so we don't go crazy by accident
lockdir=/tmp/${host}_${sname}_`date +%Y-%m-%d-%H`
# this adds minutes, but sets the units of minutes to 0, which gives
# use a ten minute window
lockdir=/tmp/${host}_${sname}_`date +%Y-%m-%d-%H-%M | sed -e 's/.$/0/'`


fixit="no"
case "$state" in
    "OK")
	echo "$myname: OK $sname problem"
	;;
    "WARNING")
	echo "$myname: warning $sname problem"
	;;
    "UNKNOWN")
	echo "$myname: unknown $sname problem"
	;;
    "CRITICAL")
	echo "$myname: critical $sname problem"
	case "$type" in
	    "HARD")
		fixit="yes"
		;;
	    "SOFT")
		# used to be -gt 2, so on the third try, now on the 2nd
		if [ "$attempt" -ge 2 ]; then
		    fixit="yes"
		fi
		;;
	    *)
		echo "$myname: strange type '$type'"
		;;
	esac
	;;
    *)
	echo "$myname: strange state '$state'"
	;;
esac

case "$output" in
    *autosupport?message?failed*)
	# we can fix this!
	;;
    *)
	# don't know how to fix anything else
	fixit="no"
	;;
esac

if [ "$fixit" != "yes" ]; then
    # echo "NOT fixing $output" | mail -s "fix $sname on $host" $debugmail
    exit 0
fi

# echo need to fixit | mail -s "fix $sname on $host" $debugmail

if [ -d "$lockdir" ]; then
    echo Because we had already done it once this deca-minute ... | mail -s "did NOT send autosupport test message for $sname on $host" $mailto
    echo "$myname: oops lockdir $lockdir already exists, doing nothing"
    exit 0
fi
mkdir "$lockdir"
if [ $? -ne 0 ]; then
    echo "$myname: oops mkdir $lockdir failed, doing nothing"
    exit 0
fi




# actually try to trigger autosupport test mail
ssh "$host" options autosupport.doit \"testing - $myname autosupport reset\"

mail -s "autosupport reset of failed $sname on $host" $mailto <<EOF
FYI: The $myname script attempted to cause an autosupport test
messages because the $sname service
on host $host said it was in a failed state after $attempt attempts.

Trigger Notes:
Service: $desc
Check Output: $output
Execution Time: $exectime
EOF

exit 0
